#include "EasyCOM.H"
#include "TWSI.H"


//----- TWSI -----//
extern BYTE OutLen;
extern BYTE OutBuffer[TWSI_MAX];
extern void Initial_TWSI( void );
extern void TWSI_Send_Data_To_Device( void );
extern void TWSI_Send_Data_To_PC( void );

void USB_Event( void );
void UART_Event( void );


void main( void )
  { Initial();                                   // Do not remove
    
    Initial_TWSI();
    
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
            TWSI_Send_Data_To_Device();          // InLen and InBuffer content will be
            if ( InLen )                         // change in this function
              USB_Send_Data_To_PC( InLen , InBuffer );
            USB_Read_Data_Complete();            // Do not remove
          }
        
        TWSI_Send_Data_To_PC();
        
        USB_Event();                             // Check USB power event
        
        UART_Event();                            // Check Uart Line/Modem event
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
  }


void UART_Error( void )
  { Com.State = 0x00;
    // To do
    /*
    Rx Carrier occur ?
    Com.State |= UART_RX_CARRIER;
    
    Tx Carrier occur ?
    Com.State |= UART_TX_CARRIER;
    
    Break occur ?
    Com.State |= UART_BREAK;
    
    Ring signal occur ?
    Com.State |= UART_RING_SIGNAL;
    
    Fram error occur ?
    Com.State |= UART_FRAM_ERROR;
    
    Parity check error occur ?
    Com.State |= UART_PARITY_ERROR;
    
    Over run occur ?
    Com.State |= UART_OVER_RUN;
    */
  }


void UART_Event( void )                          // Do not remove
  { if ( Com.LC.Flag )                           // Line codeing setting by Host ( PC )
      { switch( Com.LC.BaudRate.DW )             // Com.LC.BaudRate.B[3] = LSB , Com.LC.BaudRate.B[0] = MSB
          { case 1200:   // To do
                         break;
            case 2400:   // To do
                         break;
            case 4800:   // To do
                         break;
            case 9600:   // To do
                         break;
            case 19200:  // To do
                         break;
            case 38400:  // To do
                         break;
            case 57600:  // To do
                         break;
            case 115200: // To do
                         break;
            case 7200:   // To do
                         break;
            case 14400:  // To do
                         break;
          }
        Com.LC.Flag = CLR;                       // Release this flag
      }
    if ( Com.LS.Flag )                           // Line state setting by Host ( PC )
      { // To do ( Depend on " Com.LS.State " )
      	Com.LS.Flag = CLR;                       // Release this flag
      }
    if ( Com.SB.Flag )                           // Send break by Host ( PC )
      { // To do ( Depend on " Com.SB.Time.W " )
      	Com.SB.Flag = CLR;                       // Release this flag
      }
    
    UART_Error();                                // To do
    if ( Com.State )
      USB_Send_UartState_To_PC( Com.State );
  }